package idempiere.lab.plugin.model;

import org.adempiere.util.Callback;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.adwindow.ADWindowContent;
import org.adempiere.webui.adwindow.validator.WindowValidator;
import org.adempiere.webui.adwindow.validator.WindowValidatorEvent;
import org.adempiere.webui.adwindow.validator.WindowValidatorEventType;
import org.adempiere.webui.window.FDialog;
import org.compiere.model.GridTab;
import org.compiere.model.MBPartner;
import org.compiere.util.Env;

public class CorporationWindowValidator implements WindowValidator{


	@Override
	public void onWindowEvent(WindowValidatorEvent event, Callback<Boolean> callback) {

		if (event.getName().equals(WindowValidatorEventType.BEFORE_SAVE.getName()))
		{
			String name = event.getName();
			ADWindow window = event.getWindow();
			ADWindowContent adwindowContent = window.getADWindowContent();
			GridTab gridtab = adwindowContent.getActiveGridTab();
			int C_Corporation_ID = gridtab.getRecord_ID();
			Integer C_BPartner_ID = (Integer)gridtab.getValue("C_BPartner_ID");

			if(C_BPartner_ID == null)//取引先マスタが設定されていない
			{

				FDialog.error(event.getWindow().getADWindowContent().getWindowNo(),
						event.getWindow().getComponent(), "取引先マスタを登録して下さい","Error");

			}else if(C_Corporation_ID > 0 && C_BPartner_ID.intValue() > 0){//法人マスタが新規登録ではなく、取引先マスタの入力がある場合
				MBPartner bp = MBPartner.get(Env.getCtx(), C_BPartner_ID.intValue());
				Integer BP_Corporation_ID =(Integer)bp.get_Value("C_Corporation_ID");
				if(BP_Corporation_ID != null && C_Corporation_ID != BP_Corporation_ID.intValue())
				{
					FDialog.ask(event.getWindow().getADWindowContent().getWindowNo(),
							event.getWindow().getComponent(), "主管取引先マスタの法人マスタの設定が矛盾します。このまま保存しますか?", callback);
				}else{
					callback.onCallback(Boolean.TRUE);
				}

			}else{
				callback.onCallback(Boolean.TRUE);
			}

		} else if(event.getName().equals(WindowValidatorEventType.AFTER_SAVE.getName())){

			final ADWindowContent adWindowContent =  event.getWindow().getADWindowContent();
			GridTab gridtab = adWindowContent.getActiveGridTab();
			final int C_Corporation_ID = gridtab.getRecord_ID();
			Integer C_BPartner_ID = (Integer)gridtab.getValue("C_BPartner_ID");

			if(C_BPartner_ID != null && C_BPartner_ID.intValue() > 0)//
			{
				final MBPartner bp = MBPartner.get(Env.getCtx(), C_BPartner_ID.intValue());
				Integer BP_Corporation_ID =(Integer)bp.get_Value("C_Corporation_ID");
		    	Callback<Boolean> corpCallback = new Callback<Boolean>() {
					@Override
					public void onCallback(Boolean result) {
						if (result) {
							bp.set_ValueNoCheck("C_Corporation_ID", C_Corporation_ID);
							bp.saveEx();
							adWindowContent.onRefresh(true);
						}
					}
				};

				if(BP_Corporation_ID == null || BP_Corporation_ID.intValue() == 0)
				{
					FDialog.ask(event.getWindow().getADWindowContent().getWindowNo(),
							event.getWindow().getComponent(), "主管取引先マスタの法人マスタが設定されていません。設定しますか?", corpCallback);

				}else{
					if(C_Corporation_ID != BP_Corporation_ID.intValue())
					{
						FDialog.ask(event.getWindow().getADWindowContent().getWindowNo(),
								event.getWindow().getComponent(), "主管取引先マスタの法人マスタの設定が矛盾します。主管取引先マスタの法人マスタの設定を修正しますか?", corpCallback);
					}else{
						callback.onCallback(Boolean.TRUE);
					}
				}

			}else{
				callback.onCallback(Boolean.TRUE);
			}

		} else {
			callback.onCallback(Boolean.TRUE);
		}

	}


}
